// This function takes a list of numbers (genList) as input and performs the following steps:
// 1. Generate a list of integers (ints): It creates a list of integers starting from 0 up to N-1, where N is the length of genList.
// 2. Iterate through genList: For each number in genList, it finds the closest number in the ints list.
// 3. Find the closest number: For each number in genList, it calculates the absolute difference between the current number and each number in ints. It also considers a circular difference based on the length of genList. The smallest difference determines the closest number.
// 4. Update the result: The closest number is added to a result list, and that number is removed from ints to ensure it is not reused.
// 5. Return the result: After processing all numbers in genList, the function returns the result list, which contains the closest numbers from ints in the same order as genList.
// Example:
// If genList = [0, 2.34, 4.56], the function generates ints = [0, 1, 2] and finds the closest numbers from ints for each value in genList, removing each match from ints as it proceeds.

// inlets and outlets
inlets = 1;
outlets = 1;

function list(genList) {
    // Generate the ints list as [0, 1, 2, ..., N-1] where N is the length of genList
    var ints = [];
    var genList = arrayfromargs(arguments);
	for (var i = 0; i < genList.length; i++) {
        ints.push(i);
    }

    var result = [];
    for (var genIndex = 0; genIndex < genList.length; genIndex++) {
        var gen = genList[genIndex];

        // Find the closest entry in ints to the current gen value
        var closestIndex = 0;
        var closestDiff = Math.min(
            Math.abs(ints[0] - gen),
            Math.abs(genList.length - (ints[0] - gen))
        );

        for (var i = 1; i < ints.length; i++) {
            var diff = Math.min(
                Math.abs(ints[i] - gen),
                Math.abs(genList.length - (ints[i] - gen))
            );
            if (diff < closestDiff) {
                closestDiff = diff;
                closestIndex = i;
            }
        }

        // Add the closest value to the result and remove it from ints
        result.push(ints[closestIndex]);
        ints.splice(closestIndex, 1);
    }
	outlet(0, result)
}