/*
 * Decompiled with CFR 0.152.
 */
package jode.type;

import jode.AssertError;
import jode.GlobalOptions;
import jode.type.ReferenceType;
import jode.type.Type;

public class RangeType
extends Type {
    final ReferenceType bottomType;
    final ReferenceType topType;

    public ReferenceType getBottom() {
        return this.bottomType;
    }

    public ReferenceType getTop() {
        return this.topType;
    }

    public Type getHint() {
        Type type = this.bottomType.getHint();
        Type type2 = this.topType.getHint();
        if (this.topType == Type.tNull && this.bottomType.equals(type)) {
            return type;
        }
        return type2;
    }

    public Type getCanonic() {
        return this.topType.getCanonic();
    }

    public Type getSuperType() {
        return this.topType.getSuperType();
    }

    public Type getSubType() {
        return Type.tRange(this.bottomType, Type.tNull);
    }

    public Type getCastHelper(Type type) {
        return this.topType.getCastHelper(type);
    }

    public String getTypeSignature() {
        if (this.topType.isClassType() || !this.bottomType.isValidType()) {
            return this.topType.getTypeSignature();
        }
        return this.bottomType.getTypeSignature();
    }

    public Class getTypeClass() throws ClassNotFoundException {
        if (this.topType.isClassType() || !this.bottomType.isValidType()) {
            return this.topType.getTypeClass();
        }
        return this.bottomType.getTypeClass();
    }

    public String toString() {
        return "<" + this.bottomType + "-" + this.topType + ">";
    }

    public String getDefaultName() {
        throw new AssertError("getDefaultName() called on range");
    }

    public int hashCode() {
        int n = this.topType.hashCode();
        return (n << 16 | n >>> 16) ^ this.bottomType.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof RangeType) {
            RangeType rangeType = (RangeType)object;
            return this.topType.equals(rangeType.topType) && this.bottomType.equals(rangeType.bottomType);
        }
        return false;
    }

    public Type intersection(Type type) {
        if (type == Type.tError) {
            return type;
        }
        if (type == Type.tUnknown) {
            return this;
        }
        Type type2 = this.bottomType.getSpecializedType(type);
        Type type3 = this.topType.getGeneralizedType(type);
        Type type4 = type3.equals(type2) ? type3 : (type3 instanceof ReferenceType && type2 instanceof ReferenceType ? ((ReferenceType)type3).createRangeType((ReferenceType)type2) : Type.tError);
        if ((GlobalOptions.debuggingFlags & 4) != 0) {
            GlobalOptions.err.println("intersecting " + this + " and " + type + " to " + type4);
        }
        return type4;
    }

    public RangeType(ReferenceType referenceType, ReferenceType referenceType2) {
        super(103);
        if (referenceType == Type.tNull) {
            throw new AssertError("bottom is NULL");
        }
        this.bottomType = referenceType;
        this.topType = referenceType2;
    }
}

