/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import jode.GlobalOptions;
import jode.expr.Expression;
import jode.expr.LocalLoadOperator;
import jode.expr.LocalStoreOperator;
import jode.expr.MonitorEnterOperator;
import jode.expr.StoreInstruction;
import jode.flow.InstructionBlock;
import jode.flow.SequentialBlock;
import jode.flow.StructuredBlock;
import jode.flow.SynchronizedBlock;

public class CompleteSynchronized {
    public static boolean enter(SynchronizedBlock synchronizedBlock, StructuredBlock structuredBlock) {
        if (!(structuredBlock.outer instanceof SequentialBlock)) {
            return false;
        }
        SequentialBlock sequentialBlock = (SequentialBlock)synchronizedBlock.outer;
        if (!(sequentialBlock.subBlocks[0] instanceof InstructionBlock)) {
            return false;
        }
        Expression expression = ((InstructionBlock)sequentialBlock.subBlocks[0]).getInstruction();
        if (!(expression instanceof MonitorEnterOperator)) {
            return false;
        }
        Expression expression2 = ((MonitorEnterOperator)expression).getSubExpressions()[0];
        if (!(expression2 instanceof LocalLoadOperator) || ((LocalLoadOperator)expression2).getLocalInfo() != synchronizedBlock.local.getLocalInfo()) {
            return false;
        }
        if (GlobalOptions.verboseLevel > 0) {
            GlobalOptions.err.print('s');
        }
        synchronizedBlock.isEntered = true;
        synchronizedBlock.moveDefinitions(structuredBlock.outer, structuredBlock);
        structuredBlock.replace(structuredBlock.outer);
        return true;
    }

    public static boolean combineObject(SynchronizedBlock synchronizedBlock, StructuredBlock structuredBlock) {
        if (!(structuredBlock.outer instanceof SequentialBlock)) {
            return false;
        }
        SequentialBlock sequentialBlock = (SequentialBlock)structuredBlock.outer;
        if (!(sequentialBlock.subBlocks[0] instanceof InstructionBlock)) {
            return false;
        }
        InstructionBlock instructionBlock = (InstructionBlock)sequentialBlock.subBlocks[0];
        if (!(instructionBlock.getInstruction() instanceof StoreInstruction)) {
            return false;
        }
        StoreInstruction storeInstruction = (StoreInstruction)instructionBlock.getInstruction();
        if (!(storeInstruction.getLValue() instanceof LocalStoreOperator)) {
            return false;
        }
        LocalStoreOperator localStoreOperator = (LocalStoreOperator)storeInstruction.getLValue();
        if (localStoreOperator.getLocalInfo() != synchronizedBlock.local.getLocalInfo() || storeInstruction.getSubExpressions()[1] == null) {
            return false;
        }
        synchronizedBlock.object = storeInstruction.getSubExpressions()[1];
        synchronizedBlock.moveDefinitions(structuredBlock.outer, structuredBlock);
        structuredBlock.replace(structuredBlock.outer);
        return true;
    }
}

