/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import java.io.IOException;
import java.util.Set;
import jode.decompiler.LocalInfo;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.Expression;
import jode.flow.CompleteSynchronized;
import jode.flow.StructuredBlock;
import jode.util.SimpleSet;

public class SynchronizedBlock
extends StructuredBlock {
    Expression object;
    LocalInfo local;
    boolean isEntered;
    StructuredBlock bodyBlock;

    public void setBodyBlock(StructuredBlock structuredBlock) {
        this.bodyBlock = structuredBlock;
        structuredBlock.outer = this;
        structuredBlock.setFlowBlock(this.flowBlock);
    }

    public StructuredBlock[] getSubBlocks() {
        return new StructuredBlock[]{this.bodyBlock};
    }

    public boolean replaceSubBlock(StructuredBlock structuredBlock, StructuredBlock structuredBlock2) {
        if (this.bodyBlock != structuredBlock) {
            return false;
        }
        this.bodyBlock = structuredBlock2;
        return true;
    }

    public Set getDeclarables() {
        SimpleSet simpleSet = new SimpleSet();
        if (this.object != null) {
            this.object.fillDeclarables(simpleSet);
        } else {
            simpleSet.add(this.local);
        }
        return simpleSet;
    }

    public void dumpInstruction(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        if (!this.isEntered) {
            tabbedPrintWriter.println("MISSING MONITORENTER");
        }
        tabbedPrintWriter.print("synchronized (");
        if (this.object != null) {
            this.object.dumpExpression(0, tabbedPrintWriter);
        } else {
            tabbedPrintWriter.print(this.local.getName());
        }
        tabbedPrintWriter.print(")");
        tabbedPrintWriter.openBrace();
        tabbedPrintWriter.tab();
        this.bodyBlock.dumpSource(tabbedPrintWriter);
        tabbedPrintWriter.untab();
        tabbedPrintWriter.closeBrace();
    }

    public void simplify() {
        if (this.object != null) {
            this.object = this.object.simplify();
        }
        super.simplify();
    }

    public boolean doTransformations() {
        StructuredBlock structuredBlock = this.flowBlock.lastModified;
        return !this.isEntered && CompleteSynchronized.enter(this, structuredBlock) || this.isEntered && this.object == null && CompleteSynchronized.combineObject(this, structuredBlock);
    }

    public SynchronizedBlock(LocalInfo localInfo) {
        this.local = localInfo;
    }
}

