% Locally optimised Improving Hit-and-Run-style search for
% minimum-spectral-entropy scales.
tic;

% PARAMETERS:
numSearchesPerPlace = 100;  % as in '1st place', '2nd place', etc.
numPlaces = 5;
numNotes = 7;
minStep = 20;

% INITIALISE:
leaderboard = zeros(numNotes-1, numPlaces);
entropies = zeros(1, numPlaces);
progress = zeros(1+numSearchesPerPlace, numPlaces);

% MAIN LOOP
for pl = 1:numPlaces,
    % INITIALISE THE SEARCH:
    taboo = leaderboard(:,1:(pl-1));
    [bestH, bestx] = TabooCheck(minStep*(1:(numNotes-1))' + (1200-numNotes*minStep)*sort(rand(numNotes-1, 1)),taboo);
    %while TabooCheck(bestx,taboo) > 0,
    %    [bestH, bestx] = LocalSearchGrad(minStep*(1:(numNotes-1))' + (1200-numNotes*minStep)*sort(rand(numNotes-1, 1)));
    %end
    progress(1, pl) = bestH;
    
    % INNER LOOP:
    for search = 1:numSearchesPerPlace,
        fprintf('Search #%d.%d\n',pl,search);
        xwhither = minStep*(1:(numNotes-1))' + (1200-numNotes*minStep)*sort(rand(numNotes-1, 1));
        [t, fval] = fminbnd(@(t) TabooCheck((1-t)*bestx+t*xwhither,taboo), 0, 1);
        if fval<bestH,
            fprintf('New best found.\n');
            [bestH, bestx] = LocalSearchGrad((1-t)*bestx+t*xwhither);
        end
        progress(search+1, pl) = bestH;
    end
    leaderboard(:, pl) = bestx;
    entropies(pl) = bestH;
end

scales = [zeros(1,numPlaces); leaderboard; 1200*ones(1,numPlaces)];
steps = diff(scales);
lexiSteps = nan(numNotes,numPlaces);
for scale = 1:numPlaces
   [~,minInd] = min(steps(:,scale));
   lexiSteps(:,scale) = circshift(steps(:,scale),-(minInd-1)) ;
end
leaderboard = cumsum(lexiSteps);
leaderboard(numNotes,:) = [];

fprintf('Scales with entropies:\n');
%disp([zeros(numPlaces, 1), leaderboard', entropies']),
for pl=1:numPlaces,
    fprintf('%6.1f   ', [0;leaderboard(:,pl)]);
    fprintf('%.4f\n', entropies(pl));
end
if min(diff(entropies)) < 0,  %  or some other tolerance?
    fprintf('At least one search found a better scale than some previous search. That''s a sign that numSearchesPerPlace should probably be higher.\n');
else
    fprintf('Entropies are nondecreasing (to within tolerance), in accordance with the hope that we''re finding all optima in sequence.\n');
end
toc

D = MakeDistanceMatrix(leaderboard),

% save(['topten', datestr(now,'yyyy-mmm-dd-HH-MM'), '.mat'], 'leaderboard', 'entropies', 'D');

%% Plot scales' interval content and form
% {
q = 1200;
tickSize = 100;
sigma = 6;
winLen = 6;

for i=1:numPlaces
    scales = [zeros(1,numPlaces); leaderboard];
    scale = scales(:,i);
    scaleOptPcInt = expectationTensor(q, sigma, winLen, scale, 0, 1, 2, 0);
    
    scaleOptPcIntPlot = [scaleOptPcInt scaleOptPcInt(1)];
    
    figure(i)
    stairs(scaleOptPcIntPlot,'LineWidth',2,'Color','black')
    axis([1,q+1,0,max(scaleOptPcIntPlot)*1.1])
    set(gca,'XTick',1:tickSize:q)
    set(gca,'XTickLabel',0:tickSize/100:q/100)
    set(gca,'YTick',0:4:12)
    ax = gca;
    ax.FontSize = 24;
    ax.LineWidth = 1.5;
    ax.Box = 'off';
    grid on
end

%%
sigma = 0;
for i=1:numPlaces
    scales = [zeros(1,numPlaces); leaderboard];
    scale = scales(:,i);
    scaleOptPcInt = expectationTensor(q, sigma, winLen, scale, 0, 0, 1, 0);
    
    scaleOptPcIntPlot = circshift(scaleOptPcInt,[0 round(-sigma*winLen/2)]);
    figure(i+numPlaces)
    polarplot(scaleOptPcIntPlot,'LineWidth',2,'Color','black')
    ax = gca;
    ax.ThetaDir = 'clockwise';
    ax.ThetaZeroLocation = 'top';
    ax.ThetaTickLabel = 1*(0:11);
    ax.RTick = [];
    ax.FontSize = 24;
end

%%
figure(2*numPlaces+1)
plot(0:numSearchesPerPlace, progress); xlabel('Line searches'); ylabel('Best entropy yet seen'); legend(num2str((1:numPlaces)'));
toc,

%}

