function [fval,x] = LocalSearchGrad(x)
% An exploratory function; inputs starting point, and outputs bottom of local basin.

nNotes = length(x)+1;
minStep = 30;
angfac = 2*pi/1200;
PBcon = @(x) deal([], [1+sum(cos(angfac*x)), sum(sin(angfac*x))], [], angfac*[-sin(angfac*x), cos(angfac*x)]);
A = [zeros(1,nNotes-1); eye(nNotes-1)] - [eye(nNotes-1);zeros(1,nNotes-1)];
b = [-minStep*ones(nNotes-1,1); 1200-minStep];
options = optimoptions(@fmincon,'SpecifyObjectiveGradient',true,'SpecifyConstraintGradient',true,'Display','off');
[x,fval] = fmincon(@scaleSpectralEntropyIZWG, x, A, b, [], [], zeros(1,nNotes-1), 1200*ones(1,nNotes-1), PBcon, options);
% [x,fval] ...
%     = fmincon(@scaleSpectralEntropyIZWG, x, A, b, [], [], zeros(1,nNotes-1), 1200*ones(1,nNotes-1), [], options);