function Dist = MakeDistanceMatrix(lb)
% Inputs a matrix where each column is a scale with an implicit zero,
% and outputs the matrix of pairwise distances between scales.
% For each pair, the distance is the lowest distance under any rotation,
% being the greatest absolute difference between corresponding step sizes.

D = [lb(1,:); diff(lb); 1200-lb(end,:)];
[numNotes, numSc] = size(D);
Dist = zeros(numSc);
for j=1:(numSc-1),
    circulant = toeplitz(D(:,j), [D(1,j);flipud(D(2:end,j))]);
    for k=(j+1):numSc,
        Dist(j,k) = min(max(abs(bsxfun(@minus,circulant,D(:,k)))));
        Dist(k,j) = Dist(j,k);
    end
end