function [fval, t] = TabooCheck(t,taboo)

[fval, t] = LocalSearchGrad(t);
dt = [t(1);diff(t);1200-t(end)];
dTa = [taboo(1,:); diff(taboo); 1200-taboo(end,:)];
for sc = dTa,  %  i.e., for each column
    circulant = toeplitz(sc, [sc(1);flipud(sc(2:end))]);
    if any(all(abs(bsxfun(@minus,dt,circulant))<5)),  %  5 cent threshold
        fval = inf;
    end
end