function [H, gradH] = scaleSpectralEntropyIZWG(x)

% Assumes an implicit extra '0' at the start of the scale, calculates its
% spectral entropy and the gradient.

x = [0;x(:)/1200];  %  IZ (implicit zero)

w = [0.4848, 0.2205, 0.1286, 0.0633, 0.0545, 0.0483]; % these are the "odd" weights resulting from a spectral roll-off of 0.6 with 12 harmonics
p = log2(1:2:11);
J = length(x);
K = length(p);
L = 1200; % number of points in integral estimate (1-cent resolution across the octave)
sigma = 0.005; % octaves, i.e., 6 cents

D = bsxfun(@minus, reshape((1:L)/L,1,1,L), bsxfun(@plus, x, p));
D = D - floor(D+0.5);
E = exp(-D.^2/(2*sigma^2));
F = sum(bsxfun(@times,w,sum(E)),2)/(J*sigma*sqrt(2*pi));
G = max(log(F),-750);  %  -745 seems to be the lowest log it can calculate.
H = -mean(F.*G);

if nargout>1
    gradH = -squeeze(sum(bsxfun(@times,w,E.*D),2))*(1+G(:))/(J*L*sigma^3*sqrt(2*pi));
    gradH = gradH(2:end)/1200;  %  More IZ stuff
end