function rt = Rebalance(t)

%REBALANCE Minimally alter a periodic location vector to be perfectly balanced.
%
%   Author: David Bulger 
%   Revision: 1.00  
%   Date: 2017/01/12
%
%   This routine uses Lagrange multipliers to simplify an optimization that
%   finds the closest perfectly balanced pattern to the vector t. Closest
%   as in minimizing the chord lengths between the two patterns' tones.
%   Each element of t is an angle measured in full revolutions so all
%   values are in [0,1).

t = t(:)';
xy = [cos(2*pi*t); sin(2*pi*t)];

    function rs = baldelsq(delta)
        uv = xy+delta*ones(1,length(t)); % coordinates of translation by delta
        uv = uv .* ([1;1]*(sum(uv.^2)).^-0.5); % put points back on unit circle
        rs = sum(sum(uv,2).^2); % this gives the length of the squared resultant
    end

delta = fminsearch(@baldelsq, [0;0], optimset('TolFun', 1e-20));
xy = xy+delta*ones(1,length(t));
rt = atan2(xy(2,:), xy(1,:))/(2*pi);
rt = mod(rt-rt(1),1);
end
